clc
clear
close all

%% INPUT

disp("Loading data...")

months = sprintfc('%02d', 7); % print the # of months

addpath("wc2.1_30s_prec\");
[prec, ref] = readgeoraster(strrep("wc2.1_30s_prec\wc2.1_30s_prec_%m%.tif", "%m%", months));
prec = single(prec);
prec(prec == (min(prec, [], "all"))) = NaN;

disp("Precipitation.")

%%
PET = load(strrep("PET_%m%.mat", "%m%", months));
PET = PET.PET;

disp("Potential Evapotranspiration.")

disp("COMPLETE.")

%% CALCULATION of Wetness Index -> PRECIPITATION / PET

disp("Calculating WI...")

WI = prec ./ PET;

DI = PET ./ prec;


imagesc(WI);

figure(2)
imagesc(DI)

%% save the results

disp("Saving the results...")

save(strrep("WI_%m%.mat", "%m%", months), "WI", "-v7.3")
geotiffwrite(strrep("WI_%m%.tif", "%m%", months), WI, ref);

disp("COMPLETE.")
